function ctrl = designBevShiftLogic(veh)
arguments
    veh
end

% User settings
ctrl.shiftMinTime = 2; % s
ctrl.downshiftDelay = 6; % s
ctrl.upshiftDelay = 6; % s
ctrl.ratioEarlyUp = 24;
ctrl.ratioEarlyDown = 24;
ctrl.maxGearSkip = 2; % Maximum skippable gears
ctrl.trqRes = 0; % Torque reserve for efficiency shifts
ctrl.effHyst = 0.97;

% Identify ratedSpd
if isfield(veh.em, 'ratedSpd')
    n_rated = veh.em.ratedSpd;
else
    maxTrqCurve = @(x) veh.em.maxTrq(x);
    [spd_maxTrq, maxTrq] = fminbnd(@(x) -maxTrqCurve(x), 0, veh.em.maxSpd);
    n_rated = spd_maxTrq;
end

% Identify shift polygons
maxPwrCurve = @(spd) veh.em.maxTrq(spd) .* spd;
[spd_maxPwr, maxPwr] = fminbnd(@(x) -maxPwrCurve(x), 0, veh.em.maxSpd);
maxPwr = -maxPwr;

% Identify n_P80h
pwrBrk = veh.em.maxTrq.Values .* veh.em.maxTrq.GridVectors{1};
idx = ( pwrBrk(1:end-1) > 0.80 * maxPwr ) & ( pwrBrk(2:end) < 0.80 * maxPwr );
idx = find(idx) + 1;
if length(idx) > 1
    error("?")
end
n_r = veh.em.maxTrq.GridVectors{1}(idx);
n_l = veh.em.maxTrq.GridVectors{1}(idx-1);
P_r = veh.em.maxTrq.Values(idx) .* n_r;
P_l = veh.em.maxTrq.Values(idx-1) .* n_l;
n_P80h = n_l + ( 0.8*maxPwr - P_l ) / ( P_r - P_l ) * ( n_r - n_l );
if isempty(n_P80h)
    n_P80h = n_rated;
end

% Store
ctrl.n_rated = n_rated;
ctrl.n_P80h = n_P80h;
ctrl.n_max = veh.em.maxSpd;

end
